<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Calendar extends Model
{
    use HasFactory;

    protected $fillable = [
        'association_id',
        'title',
        'description',
        'date',
        'media_id',
        'link',
        'status',
    ];

    protected $casts = [
        'date' => 'datetime:Y-m-d',
    ];

    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    public function scopeFilterCalendars($query)
    {
        if (request()->filled('title')) {
            $query->where('title', 'like', '%' . request('title') . '%');
        }
        if (request()->filled('type')) {
            $query->where('type', request('type'));
        }
        if (request()->filled('status')) {
            $query->where('status', request('status'));
        }
        if (request()->filled('date')) {
            $query->whereDate('date', date('Y-m-d', strtotime(request('date'))));
        }
        if (request()->filled('month')) {
            $query->whereMonth('date', date('m', strtotime(request('month'))));
        }

        // Filter for past dates
        if (request()->filled('past') && request('past') === 'true') {
            $query->whereDate('date', '<', now());
        }

        // Filter for upcoming dates
        if (request()->filled('upcoming') && request('upcoming') === 'true') {
            $query->whereDate('date', '>', now());
        }
    }

    /**
     * @return BelongsTo
     */
    public function media(): BelongsTo
    {
        return $this->belongsTo(Media::class, 'media_id');
    }
}
