<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AssociationUser extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'association_id',
        'user_member_id', // = unique_id (users table)
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function association()
    {
        return $this->belongsTo(User::class, 'association_id');
    }
}
