<?php

namespace App\Models;

use App\Enums\AssociationEnum;
use App\Enums\RoleEnum;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class AssociationDetail extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'association_id',
        'logo',
        'about',
        'vision',
        'mission',
        'badge_media_id',
        'card_media_id',
        'enable_otp_login',
        'otp_via_email',
        'otp_via_whatsapp',
    ];

    public function media(): BelongsTo
    {
        return $this->belongsTo(Media::class, 'logo');
    }

    public function badge(): BelongsTo
    {
        return $this->belongsTo(Media::class, 'badge_media_id');
    }
    public function card(): BelongsTo
    {
        return $this->belongsTo(Media::class, 'card_media_id');
    }

    public function isOtpLoginEnabled(): bool
    {
        return $this->enable_otp_login == AssociationEnum::YES &&
            (
                $this->sendsOtpViaEmail() ||
                $this->sendsOtpViaWhatsapp()
            );
    }

    public function sendsOtpViaEmail(): bool
    {
        return $this->otp_via_email == AssociationEnum::YES;
    }

    public function sendsOtpViaWhatsapp(): bool
    {
        return $this->otp_via_whatsapp == AssociationEnum::YES;
    }
}
