<?php

namespace App\Jobs;

use App\Models\MailTemplateCampaign;
use App\Rules\DisposableEmailRule;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;
use \Mailjet\Client as MailjetClient;
use \Mailjet\Resources;

class SendEventMailJob implements ShouldQueue
{
    use Queueable, Dispatchable, InteractsWithQueue, SerializesModels;

    protected array $from;

    protected array $to;

    protected $subject;

    protected $template;

    protected $data;

    protected $extra;

    protected $attachments;

    protected array $ccs;

    protected array $bccs;

    /**
     * Create a new job instance.
     */
    public function __construct($from, $to, $subject, $template, $data, $attachments, $extra = [], $ccs = [], $bccs = [])
    {
        $this->from = $from;

        $this->to = $to;

        $this->subject = $subject;

        $this->template = $template;

        $this->data = $data;

        $this->attachments = $attachments;

        $this->extra = $extra;

        $this->ccs = $this->formatEmails($ccs);

        $this->bccs = $this->formatEmails($bccs);
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        // $apiKey = config('mail.mailers.mailjet.key');
        // $apiSecret = config('mail.mailers.mailjet.secret');
        $apiKey = '35bae179638bd4e81c47a0c1687bc4f8';
        $apiSecret = 'b46bef046f4d8ece9728db1e5c6a251d';

        $mj = new MailjetClient($apiKey, $apiSecret, true, ['version' => 'v3.1']);
        try {
            $toMails = $this->removeDisposableEmails();

            if (empty($toMails)) {
                Log::info("Disposable mail campaign.");
                return;
            }

            // USING V3.1 Package
            $body = [
                'Messages' => [
                    [
                        'From' => $this->from,
                        'To' => $toMails,
                        'Subject' => $this->subject,
                        'TemplateID' => (int) $this->template,
                        'TemplateLanguage' => true,
                        'Variables' => $this->data,
                        'Attachments' => $this->attachments
                    ]
                ]
            ];

            if (!empty($this->ccs)) {
                $body['Messages'][0]['Cc'] = $this->ccs;
            }
            if (!empty($this->bccs)) {
                $body['Messages'][0]['Bcc'] = $this->bccs;
            }

            Log::info("email body".json_encode($body));

            /**** DO NOT REMOVE COMMENT ****/
            // This is how varibles defined in templates
            //{{ var:contact:"" }}
            // {{ var:email:"" }}

            $response = $mj->post(Resources::$Email, ['body' => $body]);

            Log::info("mail jet response :: " . json_encode($response->getData()));
            $campaign = $this->getMailTemplateCampaign();
            if ($response->success()) {
                if ($campaign) {
                    Log::info("Email Job Campaign Handle Success");
                    $campaign->handleMailSuccess($this->extra['user_id']);
                }
            } else {
                if ($campaign) {
                    Log::error("Email Job Campaign Handle Error");
                    $campaign->handleMailFailed($this->extra['user_id']);
                }
            }
        } catch (\Exception $exception) {
            dd($exception);
            Log::error("Email Sending Fail: " . $exception->getMessage());
            $campaign = $this->getMailTemplateCampaign();
            if ($campaign) {
                Log::error("Email Job Campaign Handle Error");
                $campaign->handleMailFailed($this->extra['user_id']);
            }
        }
    }

    protected function getMailTemplateCampaign(): ?MailTemplateCampaign
    {
        Log::info("Get mail template campaign id:: " . json_encode($this->extra));
        if (isset($this->extra["mail_template_campaign_id"])) {
            return MailTemplateCampaign::find($this->extra["mail_template_campaign_id"]);
        }
        return null;
    }

    protected function removeDisposableEmails()
    {
        $disposableEmailRule = new DisposableEmailRule();
        $cleanedEmails = [];
        foreach ($this->to as $to) {
            $email = $to['Email'];
            if (!$disposableEmailRule->isDisposable($email)) {
                // $cleanedEmails[] = $email; // Add to cleaned array if not disposable
                $cleanedEmails[] = ['Email' => $email];
            }
        }
        return $cleanedEmails;
    }

    protected function formatEmails($emails): array
    {
        if (is_string($emails)) {
            $emails = explode(',', $emails);
        }

        return array_filter(array_map(function ($email) {
            $trimmed = trim($email);
            return filter_var($trimmed, FILTER_VALIDATE_EMAIL) ? ['Email' => $trimmed] : null;
        }, $emails));
    }

    protected function getDemoPayload()
    {
        return [
            'Messages' => [
                [
                    'From' => [
                        'Email' => 'shyam@vdotechnologies.in',
                        'Name' => "Me"
                    ],
                    'To' => [
                        [
                            'Email' => 'testerstesting.st@gmail.com',
                            'Name' => "You"
                        ]
                    ],
                    'Subject' => "Test!",
                    'TextPart' => "Greetings from Mailjet!",
                    'HTMLPart' => "<h3>Dear passenger 1, welcome to <a href=\"https://www.mailjet.com/\">Mailjet</a>!</h3>
                    <br />May the delivery force be with you!"
                ]
            ]
        ];

    }
}
