<?php

namespace App\Jobs;

use App\Models\AssociationUserFcmToken;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;
use Kreait\Firebase\Factory;
use Kreait\Firebase\Messaging\CloudMessage;
use Kreait\Firebase\Messaging\Notification;

class SendAssociationNotificationJob implements ShouldQueue
{
    use Queueable;

    protected $title;
    protected $body;
    protected $associationId;

    /**
     * Create a new job instance.
     */
    public function __construct($title, $body, $associationId)
    {
        $this->title = $title;
        $this->body = $body;
        $this->associationId = $associationId;
    }

    /**
     * Execute the job.
     */
    public function handle()
    {
        try {
            $tokens = AssociationUserFcmToken::where('association_id', $this->associationId)->pluck('token')->toArray();

            Log::info("Sending notifications for Association ID: {$this->associationId}");

            if (!file_exists(storage_path('credentials/association-firebase-credentials.json'))) {
                Log::error("Firebase credentials file not found");
                return false;
            }

            $factory = (new Factory())->withServiceAccount(storage_path('credentials/association-firebase-credentials.json'));
            $messaging = $factory->createMessaging();

            $notification = Notification::create($this->title, $this->body);

            $chunks = array_chunk($tokens, 500);

            foreach ($chunks as $chunk) {
                $message = CloudMessage::new()->withNotification($notification);
                try {
                    // Send each batch of tokens
                    $messaging->sendMulticast($message, $chunk);
                    Log::info("Notifications sent successfully for association ID: {$this->associationId}");
                } catch (\Exception $e) {
                    Log::error("Send Notification Error for association ID {$this->associationId}: " . $e->getMessage());
                }
            }

            return true;
        } catch (\Exception $e) {
            Log::error("Send Notification Error for association ID {$this->associationId}: " . $e->getMessage());
            return false;
        }
    }
}
