<?php

namespace App\Jobs\Meta;

use App\Enums\MessageCampaignEnum;
use App\Models\MessageCampaign;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class StartMessageCampaign implements ShouldQueue
{
    use Queueable;

    protected $messageCampaignId;

    protected $host;

    /**
     * Create a new job instance.
     */
    public function __construct($host, $messageCampaignId)
    {
        $this->host = $host;

        $this->messageCampaignId = $messageCampaignId;
    }
    /**
     * @return MessageCampaign
     */
    protected function getCampaign()
    {
        return MessageCampaign::find($this->messageCampaignId);
    }
    /**
     * Execute the job.
     */
    public function handle(): void
    {
        $messageCampaign = $this->getCampaign();

        $messageCampaign->status = MessageCampaignEnum::IN_PROGRESS;
        $messageCampaign->save();

        foreach ($messageCampaign->users as $userId) {

            $cu = $messageCampaign->campaignUsers()->create([
                "user_id" => $userId,
            ]);

            SendCampaignMessage::dispatchSync($this->host, $cu->id);
        }
    }
}
