<?php

namespace App\Jobs\Meta;

use App\Helpers\MetaClient;
use App\Models\Message;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class SendMediaMessage implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    use MetaLog;

    /**
     * @var string
     */
    protected $host;

    /**
     * @var int
     */
    protected $messageId;

    protected $mediaPath;

    /**
     * Create a new job instance.
     */
    public function __construct($host, $messageId, $mediaPath)
    {
        $this->host = $host;
        $this->messageId = $messageId;
        $this->mediaPath = $mediaPath;
    }

    /**
     * @return Message
     */
    protected function getMessage()
    {
        return Message::find($this->messageId);
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        $message = $this->getMessage();

        $receiver = $message->receiverUser;

        $this->logInfo(["receiver_id" => $receiver->id, "message" => $message->message]);

        $log = $this->createLog("send_media_message", $message);

        $media =  $this->host . "/storage/" . $this->mediaPath;

        $response = MetaClient::api()->sendMediaMessage($receiver->full_mobile_number, $media, $message->type);

        $json = $response->json();
        $this->saveResponse($log, $json);

        if ($response->ok()) {
            $message->message_id = $json['messages'][0]['id'] ?? null;
            $message->save();
        } else {
            $message->status = 'failed';
            $message->save();
            $this->logError(["error" => ["receiver_id" => $receiver->id, "message" => $message->message]]);
        }
    }
}
