<?php

namespace App\Jobs\Meta;

use Illuminate\Support\Facades\Log;

trait MetaLog
{
    /**
     * @param $name
     * @param $data
     * @return \App\Models\MetaLog
     */
    public function createLog($name, $data)
    {
        $this->logInfo($data);
        return \App\Models\MetaLog::create([
            "name" => $name,
            "request" => $data
        ]);
    }

    /**
     * @param \App\Models\MetaLog $log
     * @param $json
     */
    public function saveResponse(\App\Models\MetaLog $log, $json)
    {
        $log->response = $json;
        $log->save();
    }

    public function logInfo($data)
    {
        Log::info(get_class($this) . ": " . json_encode($data));

        // "error": "The stream or file "/var/www/html/vdoconfrence/storage/logs/meta-2024-10-30.log 
        //could not be opened in append mode: Failed to open stream: Permission denied\nThe exception occurred while attempting to log
        // Log::channel("meta")->info(get_class($this) . ": " . json_encode($data));
    }

    public function logError($data)
    {
        Log::error(get_class($this) . ": " . json_encode($data));

        // "error": "The stream or file "/var/www/html/vdoconfrence/storage/logs/meta-2024-10-30.log 
        //could not be opened in append mode: Failed to open stream: Permission denied\nThe exception occurred while attempting to log
        // Log::channel("meta")->error(get_class($this) . ": " . json_encode($data));
    }
}
