<?php

namespace App\Jobs\Meta;

use App\Helpers\MetaClient;
use App\Models\MessageTemplate;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class CreateTemplateJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;
    use MetaLog;

    protected $templateId;

    /**
     * Create a new job instance.
     * @param $templateId
     */
    public function __construct($templateId)
    {
        $this->templateId = $templateId;
    }

    public function getTemplate()
    {
        return MessageTemplate::find($this->templateId);
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        $api = new MetaClient();

        $template = $this->getTemplate();

        $payload = $template->getFacebookPayload();

        $log = $this->createLog("create_message_template", $payload);

        $response = $api->createMessageTemplate($payload);

        $log->response = $response->json();
        $log->save();

        if ($response->ok()) {
            $json = $response->json();
            $template->template_id = $json["id"];
            $template->status = $json["status"];
            $template->save();
        } else {
            $template->status = "FAILED";
            $template->save();
        }
    }
}
