<?php

namespace App\Imports;

use App\Enums\TitleEnum;
use App\Models\EventFaculty;
use App\Rules\DisposableEmailRule;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;

class EventFacultyImport implements ToCollection
{
    private $eventId;

    public function __construct($eventId)
    {
        $this->eventId = $eventId;
    }


    /**
     * @param array $row
     *
     * @return \Illuminate\Database\Eloquent\Model|null
     */
    public function collection(Collection $rows)
    {
        foreach ($rows as $key => $row) {
            if ($key == 0) {
                continue;
            }

            $disposableEmailRule = new DisposableEmailRule();
            if (!($row[0]) || !($row[1]) || !($row[2]) || $disposableEmailRule->isDisposable($row[2]) || !($row[3])) {
                continue;
            }

            $titles = [
                'Dr.' => TitleEnum::DR,
                'Prof.' => TitleEnum::PROF,
                'Mr.' => TitleEnum::MR,
                'Ms.' => TitleEnum::MS,
                'Mrs.' => TitleEnum::MRS,
            ];

            $title = $titles[$row[0]] ?? TitleEnum::DR;

            EventFaculty::updateOrCreate([
                'email' => $row[2] ?? '',
            ], [
                'event_id' => $this->eventId,
                'title' => $title ?? '',
                'name' => $row[1] ?? '',
                'contact' => $row[3] ?? '',
                'institute' => $row[4] ?? '',
                'designation' => $row[5] ?? '',
                'personal_info' => $row[6] ?? '',
                'text_1' => $row[7] ?? '',
                'text_2' => $row[8] ?? '',
                'bio' => $row[9] ?? '',
            ]);
        }
    }
}
