<?php

namespace App\Http\Resources;

use App\Http\Resources\API\UserResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class PastOfficeBearerResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request)
    {
        return [
            'id' => $this->id,
            'association_id' => $this->association_id ?? null, 
            'year' => $this->year ?? null,
            'president' => new UserResource($this->president) ?? null,
            'vice_president' => new UserResource($this->vicePresident) ?? null,
            'secretary' => new UserResource($this->secretary) ?? null,
            'treasurer' => new UserResource($this->treasurer) ?? null,
        ];
    }
}
