<?php

namespace App\Http\Resources\API;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class UserResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id ?? null,
            'name' => $this->name ?? null,
            'email' => $this->email ?? null,
            'country_code' => $this->country_code ?? null,
            'contact' => $this->contact ?? null,
            'role' => $this->role ?? null,
            'cv' => $this->memberDetail->cv ?? null,
            'image' => $this->memberDetail && $this->memberDetail->image ? new MediaResource($this->memberDetail->image) : null,
            'member_details' =>  $this ? new MemberResource($this) : null,
        ];
    }
}
