<?php

namespace App\Http\Resources\API;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\Auth;

class PostResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $user = Auth::user();
        return [
            'id' => $this->id ?? null,
            'user' => new UserResource($this->user) ?? null,
            'association_id' => $this->association_id ?? null,
            'description' => $this->description ?? null,
            'link' => $this->link ?? null,
            'like_count' => $this->like_count ?? 0,
            'comment_count' => $this->comment_count ?? 0,
            'liked' => $user ? $this->isLikedByUser($user) : 0,
            'bookmarked' => $user ? $this->isBookmarkedByUser($user) : 0,
            'media' => MediaResource::collection($this->medias),
            'created_at' => getTimezoneDateTime($this->created_at , 'Y-m-d H:i:s'),
        ];
    }
}
