<?php

namespace App\Http\Resources\API;

use App\Enums\PollOptionTypeEnum;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\Auth;

class PollOptionResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
       
        $data = [
            'id' => $this->id,
            'type' => $this->type,
            'option' => $this->type == PollOptionTypeEnum::IMAGE
            ? ($this->image ? new MediaResource($this->image) : null)
            : $this->option,
            'answer_type' => $this->answer_type,
            'vote_count' => $this->vote_count,
        ];

        if ($request->auth_user) {
            $user = User::find($request->user_id);
            $data = array_merge($data, [
                'voted' => $user ? $this->isVotedByUser($user) : 0,
            ]);
        }

        return $data;
    }
}
