<?php

namespace App\Http\Resources\API;

use App\Enums\StatusEnum;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class MemberResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $memberDetail = $this->memberDetail;
        return [
            'id' => $this->id,
            'association_id' => $this->memberDetail->association_id ?? null,
            'name' => $this->name,
            'country_code' => $this->country_code,
            'contact' => $this->contact,
            'dob' => $memberDetail->dob ?? null,
            'about' => isset($memberDetail->about) ? strip_tags($memberDetail->about) : null,
            'message' => $memberDetail->message ?? null,
            'image' => $memberDetail ? new MediaResource($memberDetail->image) : null,
            'role' => $memberDetail ? new RoleResource($memberDetail->role) : null,
            'cv' => $memberDetail->cv ?? null,
            'registration_number' => $memberDetail->registration_number ?? null,
        ];
    }
}
