<?php

namespace App\Http\Resources\API;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\Log;

class LoginResource extends JsonResource
{
    public function getUser()
    {
        return User::find($this->id);
    }

    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $event = null;
        $association = null;
        if ($request->association_code) {
            $association = getAssociationFromCode($request->association_code);
            $associationUser = $this->associationUsers()->where('association_id', $association->id)->first();
        }

        if ($request->event_code) {
            $event = getEventFromCode($request->event_code);
        }

        $user = $this->getUser();

        $token = $user->createToken($user->email . '-AuthToken')->plainTextToken;

        $data = [
            'message' => 'Login Success',
            'token' => $token,
            'user_id' => $this->id ?? null,
            'name' => $this->name ?? null,
            'country_code' => $this->country_code ?? null,
            'contact' => $this->contact ?? null,
            'email' => $this->email ?? null,
            'unique_id' => $associationUser->user_member_id ?? $this->unique_id ?? null,
            'role' => $this->role ?? null,
            'image' => $this->memberDetail && $this->memberDetail->image ? new MediaResource($this->memberDetail->image) : null,
            'member_details' => $this ? new MemberResource($this) : null,
            'status' => $this->status ?? null,
            'created_at' => getTimezoneDateTime($this->created_at, 'Y-m-d H:i:s')
        ];

        if (is_object($event)) {
            if (isAssociationUser($user, $event->association_id)) {
                $data['event_id'] = $event->id;
            }
        }

        if (is_object($association)) {
            if (isAssociationUser($user, $association->id)) {
                $data['association_id'] = $association->id;
            }
        }
        return $data;
    }
}
