<?php

namespace App\Http\Resources\API\Event;

use App\Http\Resources\API\MediaResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ScrollerImageResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'title' => $this->title,
            'index' => $this->index,
            'media' => new MediaResource($this->image),
        ];
    }
}
