<?php

namespace App\Http\Resources\API\Event;

use App\Enums\StatusEnum;
use App\Http\Resources\API\MediaResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class EventVenueResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $data = [
            'id' => $this->id ?? null,
            'name' => $this->name ?? null,
            'contact' => $this->contact ?? null,
            'website_link' => $this->website_link ?? null,
            'latitude' => $this->latitude ?? null,
            'longitude' => $this->longitude ?? null,
            'start_date_time' => $this->start_date_time ?? null,
            'end_date_time' => $this->end_date_time ?? null,
            'index' => $this->index ?? null,
        ];

        if ($request->display_scroller_images) {
            $data = array_merge($data, [
                'extra' => $this->extra,
                'media' => ScrollerImageResource::collection($this->scrollerImages->where('status', StatusEnum::ACTIVE)),
            ]);
        }
        return $data;
    }
}
