<?php

namespace App\Http\Resources\API\Event;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class EventSlabResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'name' => $this->name,
            'start_date' => $this->start_date,
            'end_date' => $this->end_date,
            // 'category' => $this->eventSlabCategories,
            'category' => EventSlabCategoryResource::collection($this->eventSlabCategories),
        ];
    }
}
