<?php

namespace App\Http\Resources\API\Event;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class EventHallResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $data = [
            'id' => $this->id,
            'name' => $this->name,
            'text_color' => $this->text_color,
            'bg_color' => $this->bg_color,
            'event_day' => $this->event_day,
        ];

        if ($request->display_event_session_details) {
            $data = array_merge($data, [
                'event_sessions' => EventSessionResource::collection($this->eventParentSessions),
            ]);
        }

        return $data;
    }
}
