<?php

namespace App\Http\Resources\API\Event;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class EventFormResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $data = [
            'label' => $this->label,
            'name' => $this->name,
            'default_value' => $this->default_value,
            'helper_text' => $this->helper_text,
            'type' => $this->type,
            'options' => $this->options,
            'accepted_value' => $this->accepted_value,
            'required' => $this->required,
            'index' => $this->index,
            'field_type' => $this->field_type,
        ];

        if ($this->type == 'image') {
            $data['type'] = 'file';
            $data['default_value'] = '';
        }

        return $data;
    }
}
