<?php

namespace App\Http\Resources\API\Event;

use App\Http\Resources\API\MediaResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class EventFacultyResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'title' => $this->title,
            'name' => $this->name,
            'full_name' => $this->full_name,
            'email' => $this->email,
            'country_code' => $this->country_code,
            'contact' => $this->contact,
            'institute' => $this->institute,
            'designation' => $this->designation,
            'personal_info' => $this->personal_info,
            'text_1' => $this->text_1,
            'text_2' => $this->text_2,
            'bio' => $this->bio,
            'image' => new MediaResource($this->image),

        ];
    }
}
