<?php

namespace App\Http\Resources\API\Event;

use App\Enums\StatusEnum;
use App\Http\Resources\API\MediaResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class EventExhibitorResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $data = [
            'id' => $this->id,
            'name' => $this->name,
            'company_name' => $this->company_name,
            'sponsor_type' => $this->sponsor_type,
            'category' => new EventExhibitorCategoryResource($this->category),
            'country_code' => $this->country_code,
            'contact' => $this->contact,
            'email' => $this->email,
            'website_link' => $this->website_link,
            'brochure_link' => $this->brochure_link,
            'about' => $this->about,
            'connect' => $this->connect,
            'address' => $this->address,
            'stall' => $this->stall,
            'event_hall_name' => $this->eventHall->name ?? null,
            'event_id' => $this->event_id,
            'logo' => new MediaResource($this->logo),
        ];

        if ($request->display_scroller_images) {
            $data = array_merge($data, [
                'media' => ScrollerImageResource::collection($this->scrollerImages->where('status', StatusEnum::ACTIVE)),
            ]);
        }
        return $data;
    }
}
