<?php

namespace App\Http\Resources\API\Event;

use App\Http\Resources\API\MediaResource;
use App\Http\Resources\API\UserResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class EventEPosterResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'title' => $this->title,
            'category' => $this->EPosterCategory ? new EventEPosterCategoryResource($this->EPosterCategory) : null,
            'presenter' => $this->user ? new UserResource($this->user) : null,
            'institute' => $this->institute ?? null,
            'co_author' => $this->co_author ?? null,
            'abstract_id' => $this->abstract_id ?? null,
            'e_poster' => new MediaResource($this->media),
        ];
    }
}
