<?php

namespace App\Http\Resources\API;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CommitteeMemberResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $member = $this->member;
        return [
            'id' => $member->id,
            'index' =>$this->index, 
            'association_id' => $member->association_id,
            'name' => $member->name,
            'country_code' => $member->country_code,
            'contact' => $member->contact,
            'about' => $member->memberDetail->about,
            'media' => $member->memberDetail->image ? new MediaResource($member->memberDetail->image) : null,
            'role' => $member->memberDetail->role ? new RoleResource($member->memberDetail->role) : null,
        ];
    }
}
