<?php

namespace App\Http\Middleware;

use App\Enums\AdminLevel;
use App\Models\EventManager;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class UserRoleIsValid
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next, $role): Response
    {
        if (Auth::check() && Auth::user()->role == $role) {

            if ($role == AdminLevel::EVENT_MANAGER) {
                return app(EventManagerMiddleware::class)->handle($request, $next);
            }
            return $next($request);
        } else {
            return redirect('/');
        }
    }
}
