<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Auth;

class CheckEvent
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        ///////////////////////////////////////////////

        // $eventId = $request->header('event-id');
        // if (!$eventId) {
        //     return $this->unauthorizedResponse();
        // }

        // $event = getEventFromId($eventId);

        ///////////////////////////////////////////////

        $eventCode = $request->header('event_code');
        if (!$eventCode) {
            return $this->unauthorizedResponse();
        }

        $event = getEventFromCode($eventCode);

        //////////////////////////////////////////////////



        //////////////////////////////////////////////////
        // $user = $request->user();
        // if (!$event || !$user || $user->association_id != $event->association_id) {
        //     return response()->json(['error' => 'Event not found'], Response::HTTP_BAD_REQUEST);
        // }
        //////////////////////////////////////////////////
        if (!$event) {
            return response()->json(['error' => 'Event not found'], Response::HTTP_BAD_REQUEST);
        }
        //////////////////////////////////////////////////

        $request->attributes->set('event_id', $event->id);

        return $next($request);
    }

    /**
     * Returns unauthorized response.
     *
     * @return Response
     */
    protected function unauthorizedResponse(): Response
    {
        return response()->json(['error' => 'Unauthorized'], Response::HTTP_UNAUTHORIZED);
    }
}
