<?php

namespace App\Http\Middleware;

use App\Enums\RoleEnum;
use App\Enums\StatusEnum;
use App\Models\User;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use Symfony\Component\HttpFoundation\Response;

class CheckAuthCode
{
    /**
     * Handle an incoming request.
     *
     * @param  Request  $request
     * @param  Closure  $next
     * @return Response
     */
    public function handle(Request $request, Closure $next): Response
    {


        // $user = Auth::user();
        // if ($user->role == RoleEnum::MEMBER) {
        //     $request->attributes->set('association_id', $user->association_id);
        // } elseif ($user->role == RoleEnum::ASSOCIATION) {
        //     $request->attributes->set('association_id', $user->id);
        // }


        $associationId = $request->header('association-code');
        if (!$associationId) {
            return $this->unauthorizedResponse();
        }

        $association = getAssociationFromCode($associationId);
        if (!$association) {
            return response()->json(['error' => 'Association not found'], Response::HTTP_BAD_REQUEST);
        }

        $user = Auth::user();

        if ($user) {
            if (!isAssociationUser($user, $association->id)) {
                return response()->json(['error' => 'Association not found'], Response::HTTP_BAD_REQUEST);
            }
        }

        // if (!$association || !$user || $user->association_id != $association->id) {
        //     return response()->json(['error' => 'Association not found'], Response::HTTP_BAD_REQUEST);
        // }

        $request->attributes->set('association_id', $association->id);

        return $next($request);
    }

    /**
     * Returns unauthorized response.
     *
     * @return Response
     */
    protected function unauthorizedResponse(): Response
    {
        return response()->json(['error' => 'Unauthorized'], Response::HTTP_UNAUTHORIZED);
    }
}
