<?php

namespace App\Http\Controllers;

use App\Helpers\MetaWebhook;
use App\Models\MetaLog;
use Illuminate\Http\Request;

class WebhookController extends Controller
{
    private $hookParser;

    public function __construct()
    {
        $this->hookParser = new MetaWebhook();
    }

    public function whatsappWebhookUrlGet(Request $request)
    {
        $this->hookParser->log()->info('GET: webhook => ' . json_encode($request->all()));
        $hubMode = $request->hub_mode;
        $hubChallenge = $request->hub_challenge;
        $hubVerifyToken = $request->hub_verify_token;

        $myToken = 'bni-admin-chat-8989'; //needs to change for vdo project

        if ($hubMode == 'subscribe' && $myToken == $hubVerifyToken) {
            $this->hookParser->log()->info('GET: webhook subscribe => ' . $hubChallenge);
            return $hubChallenge;
        } else {
            $this->hookParser->log()->info('GET: webhook subscribe ERROR');
            return "Error:";
        }
    }

    public function whatsappWebhookUrlPost(Request $request)
    {
        $data = $request->all();
        $this->hookParser->log()->info('webhook => ' . json_encode($data));

        MetaLog::create([
            "name" => "webhook",
            "request" => $data,
        ]);

        $this->hookParser->parse($data);

        return "DONE";
    }
}
