<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Models\Event;
use Illuminate\Http\Request;

class EventController extends Controller
{
    public function index(Event $event)
    {

        $eventDays = $event->eventDays()->whereHas('eventSessions')->get();
        $eventSessions = $event->eventSessions()->whereNull('parent_id')
            ->whereHas('eventDay', function ($query) {
                $query->orderByDesc('date');
            })
            ->get();

        return view('frontend.event.design1', compact('event', 'eventDays', 'eventSessions'));
    }
}
