<?php

namespace App\Http\Controllers\Event;

use App\Http\Controllers\Controller;
use App\Models\EventSetting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class EventSettingController extends Controller
{
    public function index()
    {
        $eventSettings = EventSetting::where('event_id',Session::get('event_id'))->get();
        return view('event.setting.index', compact('eventSettings'));
    }

    public function update(Request $request)
    {
        $eventSettings = $request->except('_token', '_method');
        $eventId = Session::get('event_id');
        foreach ($eventSettings as $key => $data) {
            setEnvironmentVariable($key, $data, $eventId);
        }
        return redirect()->route('event.settings.index')->with('success', 'Setting Updated Successfully');
    }
}
