<?php

namespace App\Http\Controllers\Event;

use App\Http\Controllers\Controller;
use App\Models\EventPaymentMode;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class EventPaymentModeController extends Controller
{
    public function index()
    {

        $paymentMode = EventPaymentMode::where('event_id', Session::get('event_id'))->first();
        return view('event.payment-mode.index', compact('paymentMode'));
    }

    public function update(Request $request)
    {
        $data = $request->validate([
            'name' => ['required'],
            'app_key' => ['required'],
            'secret_key' => ['required'],
        ]);
        $paymentMode = EventPaymentMode::where('event_id', Session::get('event_id'))->first();
        $data['event_id'] = Session::get('event_id');
        EventPaymentMode::updateOrCreate(['id' => $paymentMode->id ?? null], $data);

        return redirect()->route('event.payment.modes.index')->with('success', 'Payment Mode Saved');
    }
}
