<?php

namespace App\Http\Controllers\Event;

use App\Helpers\SendNotification;
use App\Http\Controllers\Controller;
use App\Jobs\SendEventNotificationJob;
use App\Models\Event;
use App\Models\Notification;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class EventNotificationController extends Controller
{
    public function index(Request $request)
    {
        $eventNotifications = Notification::where('event_id', Session::get('event_id'));
        $eventNotifications = $eventNotifications->paginate(25);
        return view('event.notification.index', compact('request', 'eventNotifications'));
    }

    public function create(Request $request)
    {
        return view('event.notification.create');
    }

    public function store(Request $request, Event $event)
    {
        $data = $request->validate([
            'title' => ['required', 'string'],
            'body' => ['required', 'string'],
        ]);

        $event->eventNotifications()->create($data);
        SendEventNotificationJob::dispatchSync($request->title, $request->body, $event->id);
        return redirect()->route('event.notifications.index')->with('success', 'Notification Send Successfully');
    }

    public function destroy(Notification $notification)
    {
        $notification->delete();
        return response()->json(["status" => 200, "message" => "Notification Deleted"]);
    }
}
