<?php

namespace App\Http\Controllers\Event;

use App\Http\Controllers\Controller;
use App\Http\Traits\MediaUpload;
use App\Models\ScrollerImage;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use App\Models\Event;

class EventNoticeController extends Controller
{
    use MediaUpload;

    public function imagesIndex()
    {
        $event = getEventFromId(Session::get('event_id'));

        $title = 'Event Notices';
        $addRoute = route('event.notices.add', $event->id);

        $scrollImages = $event->noticeImages()->paginate(25);
        $type = ScrollerImage::TYPE_NOTICE;
        return view('event.scroll-images.index', compact('scrollImages', 'event', 'title', 'addRoute', 'type'));
    }

    public function imageAdd(Request $request)
    {
        $event = getEventFromId(Session::get('event_id'));

        $title = $event->title;
        $storeRoute = route('event.notices.store');
        $type = ScrollerImage::TYPE_NOTICE;
        return view('event.scroll-images.add', compact('title', 'storeRoute', 'type'));
    }

    public function imagestore(Request $request)
    {
        $request->validate([
            'title' => ['nullable', 'string'],
            'image' => ['required', 'image', 'max:3072'],
        ]);
        $event = getEventFromId(Session::get('event_id'));

        $scrollerImage = new ScrollerImage([
            'title' => $request->title ?? null,
            'index' => $request->index ?? 0,
            'media_id' => $this->upload($request->image)->id,
            'type' => ScrollerImage::TYPE_NOTICE,
        ]);
        $event->bannerImages()->save($scrollerImage);
        return redirect()->route('event.notices.index')->with('success', 'Image Saved');
    }
}
