<?php

namespace App\Http\Controllers\Event;

use App\Enums\StatusEnum;
use App\Http\Controllers\Controller;
use App\Models\Event;
use App\Models\EventMemberRole;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class EventMemberRoleController extends Controller
{
    public function index(Request $request)
    {
        $eventId = Session::get('event_id');
        $memberRoles = EventMemberRole::where('event_id', $eventId)->orderBy('id', 'asc');
        $memberRoles = $memberRoles->paginate(25);
        return view('event.member-roles.index', compact('memberRoles', 'request'));
    }

    public function create()
    {
        return view('event.member-roles.add');
    }


    public function store(Request $request, Event $event)
    {
        $request->validate([
            'name' => ['required'],
        ]);

        if (EventMemberRole::where('name', $request->name)->where('event_id', $event->id)->exists()) {
            return redirect()->back()->with('error', "The Name has already been taken.")->withInput();
        }

        $data = $request->except(['_token', '_method']);
        $data["event_id"] = $event->id;

        EventMemberRole::create($data);

        return redirect()->route('event.member.roles.index')->with('success', 'Role Created');
    }

    public function edit(EventMemberRole $memberRole)
    {
        return view('event.member-roles.edit', compact('memberRole'));
    }

    public function update(EventMemberRole $memberRole, Request $request)
    {
        $request->validate([
            'name' => ['required']
        ]);

        if (EventMemberRole::where('name', $request->name)->where('event_id', $memberRole->event_id)
            ->whereNot('id', $memberRole->id)->exists()
        ) {
            return redirect()->back()->with('error', "The Name has already been taken.")->withInput();
        }

        $data = $request->except(['_token', '_method']);

        $memberRole->update($data);
        return redirect()->route('event.member.roles.index')->with('success', 'Role Updated');
    }

    public function statusChange(EventMemberRole $memberRole)
    {
        if ($memberRole->status == StatusEnum::ACTIVE) {
            $memberRole->status = StatusEnum::INACTIVE;
        } else {
            $memberRole->status = StatusEnum::ACTIVE;
        }
        $memberRole->save();
        return response()->json(["status" => 200, "message" => "Status Changed"]);
    }

    public function destroy(EventMemberRole $memberRole)
    {
        $memberRole->delete();
        return response()->json(["status" => 200, "message" => "Role Deleted"]);
    }
}
