<?php

namespace App\Http\Controllers\Event;

use App\Http\Controllers\Controller;
use App\Models\Event;
use App\Models\EventImportantLink;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class EventImportantLinkController extends Controller
{
    public function index(Request $request)
    {
        $eventImportantLinks = EventImportantLink::where('event_id', Session::get('event_id'));
        $eventImportantLinks = $eventImportantLinks->paginate(25);
        return view('event.important-link.index', compact('request', 'eventImportantLinks'));
    }

    public function store(Request $request, Event $event)
    {
        $data = $request->validate([
            'title' => ['required', 'string'],
            'link' => ['required', 'url'],
            'index' => ['nullable', 'integer'],
        ]);
        $data["index"] = $request->index ?? EventImportantLink::max('index') + 1;
        $event->eventImportantLinks()->create($data);
        return redirect()->route('event.important.links.index')->with('success', 'Link Created');
    }

    public function update(Request $request, EventImportantLink $eventImportantLink)
    {
        $data = $request->validate([
            'title' => ['required', 'string'],
            'link' => ['required', 'url'],
            'index' => ['nullable', 'integer'],
        ]);
        $data["index"] = $request->index ?? EventImportantLink::max('index') + 1;
        $eventImportantLink->update($data);
        return redirect()->route('event.important.links.index')->with('success', 'Link Updated');
    }

    public function destroy(EventImportantLink $eventImportantLink)
    {
        $eventImportantLink->delete();
        return response()->json(["status" => 200, "message" => "Link Deleted"]);
    }
}
