<?php

namespace App\Http\Controllers\Event\EventForm;

use App\Http\Controllers\Controller;
use App\Models\Event;
use App\Models\EventFormCategory;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class CategoryController extends Controller
{
    public function index(Request $request)
    {
        $eventFormCategories = EventFormCategory::where('event_id', Session::get('event_id'));
        $eventFormCategories = $eventFormCategories->paginate(25);
        return view('event.event-form.category.index', compact('request', 'eventFormCategories'));
    }

    public function store(Request $request, Event $event)
    {
        $data = $request->validate([
            'name' => ['required', 'string'],
            'type' => ['required'],
        ]);
        $event->eventFormCategories()->create($data);
        return redirect()->route('event.forms.categories.index')->with('success', 'Category Created');
    }

    public function update(Request $request, EventFormCategory $eventFormCategory)
    {
        $data = $request->validate([
            'name' => ['required', 'string'],
            'type' => ['required'],
        ]);
        $eventFormCategory->update($data);
        return redirect()->route('event.forms.categories.index')->with('success', 'Category Updated');
    }

    public function destroy(EventFormCategory $eventFormCategory)
    {
        $eventFormCategory->delete();
        return response()->json(["status" => 200, "message" => "Category Deleted"]);
    }
}
