<?php

namespace App\Http\Controllers\Event;

use App\Http\Controllers\Controller;
use App\Models\Event;
use App\Models\EventExhibitorCategory;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class EventExhibitorCategoryController extends Controller
{
    public function index(Request $request)
    {
        $eventExhibitorCategories = EventExhibitorCategory::where('event_id', Session::get('event_id'));
        $eventExhibitorCategories = $eventExhibitorCategories->paginate(25);
        return view('event.exhibitor.category', compact('request', 'eventExhibitorCategories'));
    }

    public function store(Request $request, Event $event)
    {
        $data = $request->validate([
            'name' => ['required', 'string'],
        ]);
        $event->eventExhibitorCategories()->create($data);
        return redirect()->route('event.exhibitors.categories.index')->with('success', 'Exhibitor Category Created');
    }

    public function update(Request $request, EventExhibitorCategory $eventExhibitorCategory)
    {
        $data = $request->validate([
            'name' => ['required', 'string'],
        ]);
        $eventExhibitorCategory->update($data);
        return redirect()->route('event.exhibitors.categories.index')->with('success', 'Exhibitor Category Updated');
    }

    public function destroy(EventExhibitorCategory $eventExhibitorCategory)
    {
        $eventExhibitorCategory->delete();
        return response()->json(["status" => 200, "message" => "Exhibitor Category Deleted"]);
    }
}
