<?php

namespace App\Http\Controllers\Event;

use App\Http\Controllers\Controller;
use App\Models\Event;
use App\Models\EventDay;
use App\Models\EventSpeaker;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class EventDayController extends Controller
{
    public function index(Request $request)
    {
        $eventDays = EventDay::where('event_id', Session::get('event_id'));
        $eventDays = $eventDays->paginate(25);
        return view('event.day.index', compact('request', 'eventDays'));
    }

    public function store(Request $request, Event $event)
    {
        $data = $request->validate([
            'name' => ['required', 'string'],
            'date' => ['required', 'date'],
            'text_color' => ['required', 'regex:/^#+([a-fA-F0-9]{6}|[a-fA-F0-9]{3})$/'],
            'bg_color' => ['required', 'regex:/^#+([a-fA-F0-9]{6}|[a-fA-F0-9]{3})$/'],
        ]);
        $event->eventDays()->create([
            "name" => $data['name'],
            "date" => date("Y-m-d", strtotime($data['date'])),
            "text_color" => $data['text_color'],
            "bg_color" => $data['bg_color'],
        ]);
        return redirect()->route('event.days.index')->with('success', 'Event Day Created');
    }

    public function update(Request $request, EventDay $eventDay)
    {
        $data = $request->validate([
            'name' => ['required', 'string'],
            'date' => ['required', 'date'],
            'text_color' => ['required', 'regex:/^#+([a-fA-F0-9]{6}|[a-fA-F0-9]{3})$/'],
            'bg_color' => ['required', 'regex:/^#+([a-fA-F0-9]{6}|[a-fA-F0-9]{3})$/'],
        ]);
        $eventDay->update([
            "name" => $data['name'],
            "date" => date("Y-m-d", strtotime($data['date'])),
            "text_color" => $data['text_color'],
            "bg_color" => $data['bg_color'],
        ]);
        return redirect()->route('event.days.index')->with('success', 'Event Day Updated');
    }

    public function destroy(EventDay $eventDay)
    {
        $eventDay->delete();
        return response()->json(["status" => 200, "message" => "Event Day Deleted"]);
    }
}
