<?php

namespace App\Http\Controllers\Event;

use App\Http\Controllers\Controller;
use App\Http\Traits\MediaUpload;
use App\Models\Event;
use App\Models\EventDashboardSponsorLink;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class EventDashboardSponsorLinkController extends Controller
{
    use MediaUpload;

    public function index(Request $request)
    {
        $eventDashboardSponsorLinks = EventDashboardSponsorLink::where('event_id', Session::get('event_id'));
        $eventDashboardSponsorLinks = $eventDashboardSponsorLinks->paginate(25);
        return view('event.app.dashboard-sponsor-link.index', compact('request', 'eventDashboardSponsorLinks'));
    }

    public function create()
    {
        return view('event.app.dashboard-sponsor-link.create');
    }

    public function store(Request $request, Event $event)
    {
        $data = $request->validate([
            'name' => ['required', 'string'],
            'link' => ['required', 'url'],
            'index' => ['nullable', 'integer'],
            'image' => ['nullable', 'image', 'max:3072'],
        ]);
        if (isset($request->image)) {
            $data['media_id'] = $this->upload($request->image)->id;
        }
        $data["index"] = $request->index ?? EventDashboardSponsorLink::max('index') + 1;
        $event->eventDashboardSponsorLinks()->create($data);
        return redirect()->route('event.app.dashboard.sponsor.links.index')->with('success', 'Sponsor Link Created');
    }

    public function edit(EventDashboardSponsorLink $eventDashboardSponsorLink)
    {
        return view('event.app.dashboard-sponsor-link.edit', compact('eventDashboardSponsorLink'));
    }

    public function update(Request $request, EventDashboardSponsorLink $eventDashboardSponsorLink)
    {
        $data = $request->validate([
            'name' => ['required', 'string'],
            'link' => ['required', 'url'],
            'index' => ['nullable', 'integer'],
            'image' => ['nullable', 'image', 'max:3072'],
        ]);
        if (isset($request->image)) {
            $data['media_id'] = $this->upload($request->image)->id;
        }
        $data["index"] = $request->index ?? EventDashboardSponsorLink::max('index') + 1;
        $eventDashboardSponsorLink->update($data);
        return redirect()->route('event.app.dashboard.sponsor.links.index')->with('success', 'Sponsor Link Updated');
    }

    public function destroy(EventDashboardSponsorLink $eventDashboardSponsorLink)
    {
        $eventDashboardSponsorLink->delete();
        return response()->json(["status" => 200, "message" => "Sponsor Link Deleted"]);
    }
}
