<?php

namespace App\Http\Controllers\Event\EventCoordinator;

use App\Enums\AdminLevel;
use App\Http\Controllers\Controller;
use App\Models\Event;
use App\Models\EventManager;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class EventCoordinatorLoginController extends Controller
{
    public function eventCoordinatorLogin($eventCode, Request $request)
    {
        if ((Auth::guard('web')->check())) {
            return redirect()->back();
        }
        if (!Session::get('event_code')) {
            $event = getEventFromCode($eventCode);
        } else {
            $event = getEventFromCode(Session::get('event_code'));
        }
        if (Auth::guard('admin')->check()) {
            return redirect()->route('event.coordinator.home', $event->code);
        } else {
            return view('auth.event-coordinator-login', compact('event'));
        }
    }

    public function eventCoordinatorLoginStore(Request $request)
    {
        $this->validate($request, [
            'email' => 'required',
            'password' => 'required',
        ]);
        $credentials = $request->only('email', 'password');
        $credentials['role'] = AdminLevel::EVENT_COORDINATOR;
        if (Auth::guard('web')->check()) {
            Auth::guard('web')->logout();
            $request->session()->invalidate();
        }
        if (Auth::guard('admin')->attempt($credentials)) {
            $user = Auth::guard('admin')->user();
            $eventManager = EventManager::where('admin_id', $user->id)->first();
            $event = $eventManager->event;
            if (!$eventManager || !$event) {
                $this->logout($request);
                return redirect()->route('event.coordinator.login')->withErrors(['email' => 'Invalid credentials'])->withInput();
            }
            Session::put('event_id', $event->id);
            Session::put('event_code', $event->code);
            return redirect()->route('event.coordinator.home', $event->code);
        }
        return redirect()->route('event.coordinator.login')->withErrors(['email' => 'Invalid credentials']);
    }

    public function logout(Request $request)
    {
        $event = getEventFromCode(Session::get('event_code'));

        if (Auth::guard('admin')->check()) {
            Auth::guard('admin')->logout();
            $request->session()->invalidate();
        }
        return redirect()->route('event.coordinator.login', $event->code);
    }

    public function home()
    {
        $event = getEventFromCode(Session::get('event_code'));

        return view('home', compact('event'));
    }
}
