<?php

namespace App\Http\Controllers\Event;

use App\Enums\StatusEnum;
use App\Helpers\Wati;
use App\Http\Controllers\Controller;
use App\Models\EventConfig;
use App\Models\EventMailTemplate;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class EventConfigController extends Controller
{
    public function index()
    {
        $eventConfig = EventConfig::where('event_id', Session::get('event_id'))->first();
        $eventMailTemplates = EventMailTemplate::where('event_id', Session::get('event_id'))->where('status', StatusEnum::ACTIVE)->get();
        $token = config('wati.token');
        $url = config('wati.endpoint');
        $wati = new Wati($token, $url);
        $messageTemplates = $wati->getWatiTemplates();

        $broadcastTemplates = [];
        if ($messageTemplates['status'] === 'success') {
            $broadcastTemplates = $wati->getApprovedTemplates($messageTemplates['data']);
        }
        
        return view('event.config.index', compact('eventConfig', 'eventMailTemplates', 'broadcastTemplates'));
    }

    public function update(Request $request)
    {
        $data = $request->validate([
            'online_mail_template' => ['nullable'],
            'offline_mail_template' => ['nullable'],
            'online_wati_template' => ['nullable'],
            'offline_wati_template' => ['nullable'],
            'offline_mail_template_before_confirmation' => ['nullable'],
            'offline_wati_template_before_confirmation' => ['nullable'],
        ]);
        $data['event_id'] = Session::get('event_id');
        EventConfig::updateOrCreate(['event_id' => Session::get('event_id')], $data);

        return redirect()->route('event.config.index')->with('success', 'Event Config Saved');
    }
}
