<?php

namespace App\Http\Controllers\Event;

use App\Http\Controllers\Controller;
use App\Models\Event;
use App\Models\EventAppSponsorLink;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class EventAppSponsorLinkController extends Controller
{
    public function index(Request $request)
    {
        $eventSponsorLinks = EventAppSponsorLink::where('event_id', Session::get('event_id'));
        $eventSponsorLinks = $eventSponsorLinks->paginate(25);
        return view('event.app.sponsor-link.index', compact('request', 'eventSponsorLinks'));
    }

    public function store(Request $request, Event $event)
    {
        $data = $request->validate([
            'name' => ['required', 'string'],
            'link' => ['required', 'url'],
            'index' => ['nullable', 'integer'],
        ]);
        $data["index"] = $request->index ?? EventAppSponsorLink::max('index') + 1;
        $event->eventAppSponsorLinks()->create($data);
        return redirect()->route('event.app.sponsor.links.index')->with('success', 'Sponsor Link Created');
    }

    public function update(Request $request, EventAppSponsorLink $eventSponsorLink)
    {
        $data = $request->validate([
            'name' => ['required', 'string'],
            'link' => ['required', 'url'],
            'index' => ['nullable', 'integer'],
        ]);
        $data["index"] = $request->index ?? EventAppSponsorLink::max('index') + 1;
        $eventSponsorLink->update($data);
        return redirect()->route('event.app.sponsor.links.index')->with('success', 'Sponsor Link Updated');
    }

    public function destroy(EventAppSponsorLink $eventSponsorLink)
    {
        $eventSponsorLink->delete();
        return response()->json(["status" => 200, "message" => "Sponsor Link Deleted"]);
    }
}
