<?php

namespace App\Http\Controllers\Event;

use App\Enums\AdminLevel;
use App\Http\Controllers\Controller;
use App\Models\EventManager;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class AdminEventLoginController extends Controller
{
    public function eventLogin()
    {
        if ((Auth::guard('web')->check())) {
            return redirect()->back();
        }

        if (Auth::guard('admin')->check()) {
            return redirect()->route('event.home');
        } else {
            return view('auth.event-manager-login');
        }
    }

    public function eventLoginStore(Request $request)
    {
        $this->validate($request, [
            'email' => 'required',
            'password' => 'required',
        ]);
        $credentials = $request->only('email', 'password');
        $credentials['role'] = AdminLevel::EVENT_MANAGER;
        if (Auth::guard('web')->check()) {
            Auth::guard('web')->logout();
            $request->session()->invalidate();
        }
        if (Auth::guard('admin')->attempt($credentials)) {
            $user = Auth::guard('admin')->user();
            $eventManagerEvent = EventManager::where('admin_id', $user->id)->first();
            if (!$eventManagerEvent || !$eventManagerEvent->event) {
                $this->logout($request);
                return redirect()->route('event.login')->withErrors(['email' => 'Invalid credentials'])->withInput();
            }
            Session::put('event_id', $eventManagerEvent->event->id);
            return redirect()->route('event.home');
        }
        return redirect()->route('event.login')->withErrors(['email' => 'Invalid credentials']);
    }

    public function logout(Request $request)
    {
        if (Auth::guard('admin')->check()) {
            Auth::guard('admin')->logout();
            $request->session()->invalidate();
        }
        return redirect()->route('event.login');
    }

    public function home()
    {
        return view('home');
    }
}
