<?php

namespace App\Http\Controllers\Event;

use App\Enums\EventPageEnum;
use App\Http\Controllers\Controller;
use App\Http\Traits\MediaUpload;
use App\Models\Event;
use App\Models\EventButton;
use App\Models\EventPage;
use App\Models\Media;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class AboutUsController extends Controller
{
    use MediaUpload;
    public function index()
    {
        $eventId = Session::get('event_id');
        $aboutUs  = EventPage::where('event_id', $eventId)->where('type', EventPageEnum::ABOUT_US)->first();
        $eventButtons = EventButton::where('event_id', $eventId)->get();
        if ($aboutUs && !empty($aboutUs->media_ids)) {
            $mediaIds = is_array($aboutUs->media_ids) ? $aboutUs->media_ids : explode(',', $aboutUs->media_ids);
            $images = Media::whereIn('id', $mediaIds)->get();
        } else {
            $images = collect();
        }
        $buttons = EventButton::where('event_id', $eventId)->orderBy('index');
        $buttons = $buttons->paginate(25);
        return view('event.about-us.index', compact('aboutUs', 'images', 'eventButtons', 'eventId', 'buttons'));
    }

    public function update(Request $request, $eventId)
    {
        $data = $request->except(['_token', '_method']);
        $aboutUs  = EventPage::where('event_id', $eventId)->where('type', EventPageEnum::ABOUT_US)->first();
        $data['type'] = EventPageEnum::ABOUT_US;
        $data['event_id'] = $eventId;

        $mediaIds = [];
        if (!empty($aboutUs->media_ids)) {
            $existingMediaIds = explode(',', $aboutUs->media_ids);
            $validMediaIds = Media::whereIn('id', $existingMediaIds)->pluck('id')->toArray();
            $mediaIds = array_merge($mediaIds, $validMediaIds);
        }
        if (isset($request->images)) {
            foreach ($request->images as $image) {
                $mediaId = $this->upload($image)->id;
                $mediaIds[] = $mediaId;
            }
            $mediaIds = array_unique($mediaIds);
        }
        $data['media_ids'] = implode(',', $mediaIds);
        EventPage::updateOrCreate(['id' => $aboutUs->id ?? null], $data);
        if ($request->name && $request->link) {
            $names = $request->name;
            $links = $request->link;

            foreach ($names as $index => $name) {
                if (isset($links[$index])) {
                    $eventButtonData = [
                        'event_id' => $eventId,
                        'name' => $name,
                        'link' => $links[$index],
                    ];
                    EventButton::updateOrCreate(['event_id' => $eventId, 'name' => $name], $eventButtonData);
                }
            }
        }

        return redirect()->route('event.aboutus.index')->with('success', 'About Us Saved');
    }

    public function mediaDelete(Media $media)
    {
        $this->remove($media->path);
        $media->delete();
        return response()->json(["status" => 200, "message" => "Image Deleted"]);
    }

    public function ButtonDelete(EventButton $eventButton)
    {
        $eventButton->delete();
        return response()->json(["status" => 200, "message" => "Button Deleted"]);
    }
}
