<?php

namespace App\Http\Controllers\Event;

use App\Enums\EventPageEnum;
use App\Http\Controllers\Controller;
use App\Http\Traits\MediaUpload;
use App\Models\EventLocation;
use App\Models\EventPage;
use App\Models\Media;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class AboutCityController extends Controller
{
    use MediaUpload;
    public function index()
    {
        $eventId = Session::get('event_id');
        $aboutCity  = EventPage::where('event_id', $eventId)->where('type', EventPageEnum::ABOUT_CITY)->first();
        if ($aboutCity && !empty($aboutCity->media_ids)) {
            $mediaIds = is_array($aboutCity->media_ids) ? $aboutCity->media_ids : explode(',', $aboutCity->media_ids);
            $images = Media::whereIn('id', $mediaIds)->get();
        } else {
            $images = collect();
        }
        $locations = EventLocation::where('event_id', $eventId)->orderBy('index');
        $locations = $locations->paginate(25);
        return view('event.about-city.index', compact('aboutCity', 'images', 'eventId','locations'));
    }

    public function update(Request $request, $eventId)
    {
        $data = $request->except(['_token', '_method']);
        $aboutCity  = EventPage::where('event_id', $eventId)->where('type', EventPageEnum::ABOUT_CITY)->first();
        $data['type'] = EventPageEnum::ABOUT_CITY;
        $data['event_id'] = $eventId;
        $mediaIds = [];
        if (!empty($aboutCity->media_ids)) {
            $existingMediaIds = explode(',', $aboutCity->media_ids);
            $validMediaIds = Media::whereIn('id', $existingMediaIds)->pluck('id')->toArray();
            $mediaIds = array_merge($mediaIds, $validMediaIds);
        }
        if (isset($request->images)) {
            foreach ($request->images as $image) {
                $mediaId = $this->upload($image)->id;
                $mediaIds[] = $mediaId;
            }
            $mediaIds = array_unique($mediaIds);
        }
        $data['media_ids'] = implode(',', $mediaIds);
        EventPage::updateOrCreate(['id' => $aboutCity->id ?? null], $data);

        return redirect()->route('event.aboutCity.index')->with('success', 'About City Saved');
    }

    public function mediaDelete(Media $media)
    {
        $this->remove($media->path);
        $media->delete();
        return response()->json(["status" => 200, "message" => "Image Deleted"]);
    }
}
