<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class Controller extends BaseController
{
    use AuthorizesRequests, ValidatesRequests;

    /**
     * @param $data
     * @param int $code
     * @return \Illuminate\Http\JsonResponse
     */
    public function sendJson($data, $code = 200)
    {
        return response()->json($data, $code);
    }

    /**
     * @return \Illuminate\Http\JsonResponse
     */
    public function unauthorized()
    {
        return $this->sendError("Unauthorized!", 401);
    }

    /**
     * @param $error
     * @param int $code
     * @return \Illuminate\Http\JsonResponse
     */
    public function sendError($error, $code = 400)
    {
        return $this->sendJson([
            "error" => $error
        ], $code);
    }

    public function logError(\Exception $e, string $customMessage)
    {
        Log::error($customMessage . ": " . $e->getMessage() .
            " in " . $e->getFile() .
            " on line " . $e->getLine());
    }

    public function logInfo(string $customMessage)
    {
        Log::info($customMessage);
    }

    public function getCurrentUserId()
    {
        return Auth::id();
    }

    /**
     * Returns unauthorized response.
     *
     * @return Response
     */
    protected function unauthorizedResponse(): Response
    {
        return response()->json(['error' => 'Unauthorized'], Response::HTTP_UNAUTHORIZED);
    }

}
