<?php

namespace App\Http\Controllers\Association;

use App\Enums\StatusEnum;
use App\Http\Controllers\Controller;
use App\Http\Traits\MediaUpload;
use App\Models\Post;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;

class PostController extends Controller
{
    use MediaUpload;

    public function index(Request $request)
    {
        $posts = Post::where('association_id',Auth::user()->id)->orderByDesc('id')->paginate(10);
        return view('association.posts.index', compact('posts'));
    }

    public function destroy(Post $post)
    {
        $post->delete();
        return response()->json(["status" => 200, "message" => "Post Deleted Successfully."]);
    }
}
