<?php

namespace App\Http\Controllers\Association;

use App\Enums\RoleEnum;
use App\Http\Controllers\Controller;
use App\Models\PastOfficeBearer;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class PastOfficeBearerController extends Controller
{
    public function index(Request $request)
    {
        $pastOffBearers = PastOfficeBearer::where('association_id', Auth::user()->id)
            ->orderByDesc('year');

        if ($request->name) {
            $pastOffBearers = $pastOffBearers->searchByName($request);
        }
        $pastOffBearers = $pastOffBearers->paginate(25);

        return view('association.past-off-bearer.index', compact('pastOffBearers', 'request'));
    }

    public function create()
    {
        return view('association.past-off-bearer.add');
    }

    public function store(Request $request)
    {
        $request->validate([
            'president_id' => ['required'],
            'secretary_id' => ['required'],
            'vice_president_id' => ['required'],
            'treasurer_id' => ['required'],
        ]);

        $data = $request->except(['_token', '_method']);
        $data["association_id"] = Auth::user()->id;
        PastOfficeBearer::create($data);

        return redirect()->route('past.office.bearers.index')->with('success', 'Past Office Bearer created');
    }

    public function edit(PastOfficeBearer $pastOffBearer)
    {
        return view('association.past-off-bearer.edit', compact('pastOffBearer'));
    }

    public function update(PastOfficeBearer $pastOffBearer, Request $request)
    {
        $request->validate([
            'president_id' => ['required'],
            'secretary_id' => ['required'],
            'vice_president_id' => ['required'],
            'treasurer_id' => ['required'],
        ]);

        $data = $request->except(['_token', '_method']);
        $pastOffBearer->update($data);

        return redirect()->route('past.office.bearers.index')->with('success', 'Past Office Bearer updated');
    }

    public function destroy(PastOfficeBearer $pastOffBearer)
    {
        $pastOffBearer->delete();
        return response()->json(["status" => 200, "message" => "Past Office Bearer updated Deleted"]);
    }
}
