<?php

namespace App\Http\Controllers\Association;

use App\Enums\StatusEnum;
use App\Http\Controllers\Controller;
use App\Models\Event;
use App\Models\EventFormWorkshop;
use App\Models\EventRegistration;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class EventRegistrationController extends Controller
{
    public function index(Request $request, Event $event)
    {
        $eventParticipants = $event->eventRegistrations();

        if ($request->filter) {
            $eventParticipants->whereHas('user', function ($q) use ($request) {
                $q->where(function ($query) use ($request) {
                    $query->where('name', 'like', '%' . $request->filter . '%')
                        ->orWhere('contact', 'like', '%' . $request->filter . '%');
                });
            });
        }
        if ($request->email) {
            $eventParticipants->whereHas('user', function ($q) use ($request) {
                $q->where('email', $request->email);
            });
        }

        if ($request->export == 'export') {
            $eventParticipants = $eventParticipants->get();
            $filename = $event->title . "_event-participants.csv";
            $columns = [
                'Sr No.',
                'Name',
                'Email',
                'Contact',
                'Date',
            ];

            return exportToCsv($request, $eventParticipants, $filename, $columns, function ($eventParticipants, $index) {
                return [
                    $index,
                    $eventParticipants->user->name ?? '-',
                    $eventParticipants->user->email ?? '-',
                    $eventParticipants->user->contact ?? '-',
                    $eventParticipants->user->created_at ? $eventParticipants->user->created_at->timezone('Asia/Kolkata')->format('d-m-Y | h:i A') : '',
                ];
            });
        }
        $eventParticipants = $eventParticipants->paginate(20);
        $basicFields = getBasicFields();
        return view('association.event.participant.index', compact('event', 'eventParticipants', 'request', 'basicFields'));
    }

    public function delete(EventRegistration $eventRegistration)
    {
        if ($eventRegistration->association_id == Auth::user()->id) {
            if (isset($eventRegistration->extra['workshop'])) {
                $workshop = EventFormWorkshop::where('id', $eventRegistration->extra['workshop'])
                ->first();
                if($workshop && $workshop->no_of_registration != 0){
                    $workshop->no_of_registration -= 1;
                    $workshop->update();
                }
            }
            $eventRegistration->delete();
            return response()->json(["status" => 200, "message" => "User Unregister Successfully"]);
        }
        return response()->json(["status" => 404, "message" => "Unauthorized"]);
    }
}
